<?php

namespace App\Controllers;
use DateTime;
use Paymentez\Paymentez;
use Paymentez\Exceptions\PaymentezErrorException;
const API_LOGIN_DEV     = "NUVEISTG-EC-SERVER";
const API_KEY_DEV       = "Kn9v6ICvoRXQozQG2rK92WtjG6l08a";
// const API_LOGIN_DEV     = "TRANSTEC-EC-SERVER";
// const API_KEY_DEV       = "u5EFACF1qMSJvwkCRHARdjo8Jc374S";

class Payment extends BaseController
{
    public function Paymentsuccessmessage(): string
    {
        return view('Paymentsuccessmessage');
    }

    public function Paymenterrormessage(): string
    {
        return view('Paymenterrormessage');
    }

    /**
     * Summary of index
     * @param mixed $cardToken
     * @throws \Paymentez\Exceptions\PaymentezErrorException
     * @return \App\Controllers\null
     */
    public function index($cardToken, $duration, $subtotal, $iva): string
    {
        try {

            if(empty($cardToken)) {
                throw new PaymentezErrorException("No se genero el token de la tarjeta");
            }
            if(empty($duration)) {
                throw new PaymentezErrorException("No existe duracion");
            }
            if(empty($subtotal)) {
                throw new PaymentezErrorException("No existe subtotal");
            }
            if(empty($iva)) {
                throw new PaymentezErrorException("No hay iva");
            }
            Paymentez::init(API_LOGIN_DEV, API_KEY_DEV);
            $charge = Paymentez::charge();

            $userDetails = [
                'id' => "1111", // Field required
                'email' => "juanito@alimana.com" // Field required
            ];
/* 
Si todo va a cobrar iva deberán pasar de la siguiente manera,
 
order_amount: 56.00,
order_vat: 6.00,
order_taxable_amount: 50.00
order_tax_percentage: 12

Si tienen valores mixtos con y sin iva deberán pasar de la siguiente manera,
order_amount: 256.00,
order_vat: 6.00,
order_taxable_amount: 50.00
order_tax_percentage: 12
Para el ejemplo tomo 50 dol como imputable de iva a eso se calcula el iva que se lo pasa en el vat, tax percentage se pasa con 12 por qué cobramos aunque sea un valor con iva y en el amount estamos pasando (taxable + vat + 200) los 200 los paso como un valor sin iva
*/
            $orderDetails = [
                'amount' => $subtotal + $iva, // Field required
                'description' => "Pago parqueadero", // Field required
                'dev_reference' => "Pago parqueo de prueba", // Field required
                'vat' => $iva, // Field required 
                'taxable_amount' => $subtotal, // Validar para revisar
                'tax_percentage' => 12 // Field required
            ];

            $created = $charge->create($cardToken, $orderDetails, $userDetails);
            if($created->transaction->current_status === 'APPROVED'){
                return view('Paymentsuccessmessage');
            } else {
                return view('Paymenterrormessage');
            }
            
        } catch (PaymentezErrorException $error) {
            // See the console output for complete information
            // Access to HTTP code from paymentez service
            $code = $error->getCode();
            $message = $error->getMessage();
            echo $code .''. $message .'';
        }

        // Get transaction status
        $status = $created->transaction->status;
        // Get transaction ID
        $transactionId = $created->transaction->id;
        // Get authorization code
        $authCode = $created->transaction->authorization_code;
        return '';
    }
    public function listCards(): string
    {
        // First setup your credentials provided by paymentez
        Paymentez::init(API_LOGIN_DEV, API_KEY_DEV);
        $card = Paymentez::card();
        // Success response
        $userId = "1111";
        $listOfUserCards = $card->getList($userId);
        $totalSizeOfCardList = $listOfUserCards->result_size;
        echo "<pre>";
        print_r($totalSizeOfCardList);
        print_r($listOfUserCards);
        echo "</pre>";
        $listCards = $listOfUserCards->cards;
        // Get all data of response
        //$response = $listOfUserCards->getData();
        // Catch fail response
        try {
            
          //  $listOfUserCards = $card->getList("someUID");
            return 'alla voy';
        } catch (PaymentezErrorException $error) {
            // Details of exception
            echo $error->getMessage();
            // You can see the logs for complete information
        }
    }
    private function getToken(): string
    {
        

        $server_application_code = API_LOGIN_DEV;
        $server_app_key = API_KEY_DEV ;
        $date = new DateTime();
        $unix_timestamp = $date->getTimestamp();
        // $unix_timestamp = "1546543146";
        $uniq_token_string = $server_app_key.$unix_timestamp;
        $uniq_token_hash = hash('sha256', $uniq_token_string);
        $auth_token = base64_encode($server_application_code.";".$unix_timestamp.";".$uniq_token_hash);
        /*echo "TIMESTAMP: $unix_timestamp";
        echo "\nUNIQTOKENST: $uniq_token_string";
        echo "\nUNIQTOHAS: $uniq_token_hash";
        echo "\nAUTHTOKEN: $auth_token";*/
        return $auth_token;
    }

}
