<!DOCTYPE html>
<html>
<head>
  <title>Example | Payment Checkout Js</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <script src="https://code.jquery.com/jquery-3.5.0.min.js"></script>
  <script src="https://cdn.paymentez.com/ccapi/sdk/payment_checkout_3.0.0.min.js"></script>
</head>
<body>
<button class="js-payment-checkout">Pay with Card</button>

<div id="response"></div>

<script>
  let paymentCheckout = new PaymentCheckout.modal({
    env_mode: "stg", // `prod`, `stg`, `local` to change environment. Default is `stg`
    onOpen: function () {
      console.log("modal open");
    },
    onClose: function () {
      console.log("modal closed");
    },
    onResponse: function (response) { // The callback to invoke when the Checkout process is completed

      /*
        In Case of an error, this will be the response.
        response = {
          "error": {
            "type": "Server Error",
            "help": "Try Again Later",
            "description": "Sorry, there was a problem loading Checkout."
          }
        }
        When the User completes all the Flow in the Checkout, this will be the response.
        response = {
          "transaction":{
              "status": "success", // success or failure
              "id": "CB-81011", // transaction_id
              "status_detail": 3 // for the status detail please refer to: https://paymentez.github.io/api-doc/#status-details
          }
        }
      */
      console.log("modal response");
      document.getElementById("response").innerHTML = JSON.stringify(response);
    }
  });

  let btnOpenCheckout = document.querySelector('.js-payment-checkout');
  btnOpenCheckout.addEventListener('click', function () {
    paymentCheckout.open({
      reference: '8REV4qMyQP3w4xGmANU' // reference received for Payment Gateway
    });
  });

  window.addEventListener('popstate', function () {
    paymentCheckout.close();
  });
</script>
</body>
</html>
