<!DOCTYPE html>
<html>
<head>
  <title>Example | Payment Checkout Js</title>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://code.jquery.com/jquery-3.5.0.min.js"></script>
  <script src="https://cdn.paymentez.com/ccapi/sdk/payment_sdk_stable.min.js" charset="UTF-8"></script>
</head>
<body>
<!-- Container styling example -->
<style>
  #payment_example_div {
    max-width: 600px;
    min-width: 400px;
    margin: 10 auto;
  }

  #payment_example_div > * {
    margin: 10 auto;
  }

  .tok_btn:hover {
    cursor: pointer;
  }

  .tok_btn:disabled, #tok_btn[disabled] {
    opacity: .65;
    cursor: not-allowed;
  }

  .tok_btn {
    background: linear-gradient(to bottom, rgba(140, 197, 65, 1) 0%, rgba(20, 167, 81, 1) 100%); /* W3C, IE10+, FF16+, Chrome26+, Opera12+, Safari7+ */
    color: #fff;
    width: 80%;
    border: 1px solid rgba(46, 86, 153, 0.0980392);
    border-bottom-color: rgba(46, 86, 153, 0.4);
    border-top: 0;
    border-radius: 4px;
    font-size: 17px;
    text-shadow: rgba(46, 86, 153, 0.298039) 0px -1px 0px;
    line-height: 34px;
    -webkit-font-smoothing: antialiased;
    font-weight: bold;
    display: block;
    margin-left: 60px;
  }

  #retry_btn {
    display: none;
  }
</style>

<!--1. Create an element to contain the dynamic form.-->
<div id='payment_example_div'>
  <img src="./Grupo_2280.png" style="width: 100%; height: auto;" />
  <img src="./paymentez.png" style="width: 100%; height: auto;" />
  <table border="0" align="center">
    <tr>
      <th>Subtotal</th>
      <td>$ <?php echo $subtotal; ?></td>
    </tr>
    <tr>
      <th>IVA</th>
      <td>$ <?php echo $iva; ?></td>
    </tr>
    <tr>
      <th>Total</th>
      <td>$ <?php echo $subtotal + $iva; ?></td>
    </tr>
  </table>
  <p style="margin-left: 60px; font-family:Arial">Tarjeta de ejemplo: 4111 1111 1111 1111</p>
  <div id='tokenize_example'></div>
  <div id="response"></div>
  <button id='tokenize_btn' class='tok_btn'>Proceder pago</button>
</div>

<!-- In this example, the form loads with the page, you can custom with the event you need. -->
<script>
  // Execute immediately
  (function () {
    // === Variable to use ===
    let environment = 'stg';
    //let application_code = 'NUVEISTG-EC-CLIENT';  // Provided by Payment Gateway
    //let application_key = 'rvpKAv2tc49x6YL38fvtv5jJxRRiPs';  // Provided by Payment Gateway
    let application_code = 'TRANSTEC-EC-CLIENT';  // Provided by Payment Gateway
    let application_key = 'ikKOau1TJTGmdOLWoDs74E4wQHh1Yp';  // Provided by Payment Gateway
    let submitButton = document.querySelector('#tokenize_btn');
    
    let submitInitialText = submitButton.textContent;

    // Get the required additional data to tokenize card
    let get_tokenize_data = () => {
      let data = {
        locale: 'es',
        user: {
          id: '1111',
          email: 'juanito@alimana.com',
        },
        configuration: {
          default_country: 'ECU'
        },
      }
      return data
    }

    // === Required callbacks ===
    // Executed when was called 'tokenize' function but the form was not completed.
    let notCompletedFormCallback = message => {
      document.getElementById('response').innerHTML = `No completado: ${message}, Por favor, ingrese los datos`;
      submitButton.innerText = submitInitialText;
      submitButton.removeAttribute('disabled');
    }

    // Executed when was called 'tokenize' and the services response successfully.
    let responseCallback = response => {
      // Example of success tokenization.
      //   {
      //    "card": {
      //     "bin": "411111",
      //     "status": "valid",
      //     "token": "2508629432271853872",
      //     "message": "",
      //     "expiry_year": "2033",
      //     "expiry_month": "12",
      //     "transaction_reference": "RB-143809",
      //     "type": "vi",
      //     "number": "1111"
      //   }
      // }

      // Example of failed tokenization. The error format is always the same, only the value of type, help, description changes.
      // {
      //    "error": {
      //       "type": "Card already added: 2508629432271853872",
      //       "help": "If you want to update the card, first delete it",
      //       "description": "{}"
      //    }
      // }
      //document.getElementById('response').innerHTML = JSON.stringify(response);
      console.info({response});
      if (response.card.status == 'valid') {
        location.replace('/public/payment/index/'+response.card.token+'/'+<?php echo $duration; ?>+'/'+<?php echo $subtotal; ?>+'/'+<?php echo $iva; ?>+'/'+<?php echo $total; ?>);
      } else {
        //location.replace('/public/payment/Paymenterrormessage')
      }
    }

    // 2. Instance the [PaymentGateway](#PaymentGateway-class) with the required parameters.
    let pg_sdk = new PaymentGateway(environment, application_code, application_key);

    // 3. Generate the tokenization form with the required data. [generate_tokenize](#generate_tokenize-function)
    // At this point it's when the form is rendered on page.
    pg_sdk.generate_tokenize(get_tokenize_data(), '#tokenize_example', responseCallback, notCompletedFormCallback);

    // 4. Define the event to execute the [tokenize](#tokenize-function) action.
    submitButton.addEventListener('click', event => {
    try {
      document.getElementById('response').innerHTML = '';
      submitButton.innerText = 'Procesando pago...';
      submitButton.setAttribute('disabled', 'disabled');
      pg_sdk.tokenize();
      setTimeout(() => {
        alert('Redirigimos'); // 9473092921039219354
        //location.replace('/public/payment/Paymenterrormessage');
      }, "5000");
      event.preventDefault();
    } catch (e) {
              alert(e.message);
          }
    });
    // };
  })();

</script>

</body>
</html>
